//
//  GMSQueueViewController.m
//  GMS Sample
//
//  Created by Arkady on 8/1/13.
//  Copyright (c) 2013 Genesys. All rights reserved.
//

#import "GMSQueueViewController.h"
#import "GMSAppDelegate.h"
#import "GMSRequestViewController.h"

@interface GMSQueueViewController ()

@end

@implementation GMSQueueViewController

NSTimer *timer;

- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    [self refreshQueue:nil];
    timer = [NSTimer scheduledTimerWithTimeInterval:5.0
                                             target:self
                                           selector:@selector(refreshQueue:)
                                           userInfo:nil
                                            repeats:YES];
}

- (void) viewWillDisappear:(BOOL)animated
{
    [timer invalidate];
    [super viewWillDisappear:animated];
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

- (void)viewDidUnload {
    [self setPositionLabel:nil];
    [self setEtaLabel:nil];
    [self setThresholdLabel:nil];
    [self setTotalLabel:nil];
    [super viewDidUnload];
}
- (IBAction)refreshQueue:(id)sender {

    GMSAppDelegate *appDelegate = (GMSAppDelegate*)[[UIApplication sharedApplication] delegate];
    
    //Construct URL
    NSString *urlStr = [[[appDelegate.serverURLs[appDelegate.serverURLSelected] stringByDeletingLastPathComponent] stringByAppendingPathComponent:appDelegate.serviceID] stringByAppendingPathComponent:@"check-queue-position"];
    
    //Find GMSRequestViewController
    UITabBarController *tb = (UITabBarController *)appDelegate.window.rootViewController;
    for (id tbc in tb.viewControllers) {
        if ([tbc isKindOfClass:[UINavigationController class]] && [[tbc viewControllers][0] isKindOfClass:[GMSRequestViewController class]]) {
            GMSRequestViewController *gmsR = [tbc viewControllers][0];
            gmsR.dMenu.completionBlock = ^(NSDictionary *responseDict){
                 if ([responseDict isKindOfClass:[NSDictionary class]]) {
                     _positionLabel.text = [responseDict[@"_position"] stringValue];
                     _etaLabel.text = responseDict[@"_eta"];
                     _thresholdLabel.text = [responseDict[@"_agent_ready_threshold_passed"] stringValue];
                     _totalLabel.text = [responseDict[@"_total_waiting"] stringValue];
                }
            };
            [gmsR.dMenu submitRequest2GMS:urlStr method:@"POST" params:nil headers:nil];
        }
    }    
}
@end
